StyledStringPointStamp = function(canvas, x, y, styledString, paint, halign, valign, transformation, padx, pady)
    if (styledString) then
        halign = halign or 0
        valign = valign or 0
        padx = padx or 0
        pady = pady or 0
        local stringRect = styledString:measure()
        local padding = stringRect:height()
        local tx, ty = 0, 0
        if transformation then
            stringRect = transformation:transformRect(stringRect)
            tx, ty = transformation:transformPoint(tx, ty)
        end
        x = x + tx - halign * stringRect:width() - stringRect:minx() + padx * padding
        y = y + ty - valign * stringRect:height() - stringRect:miny() + pady * padding
        canvas:preserve(function(canvas)
            canvas:concatTransformation(Transformation:identity():translate(x, y))
                :concatTransformation(transformation)
                :setPaint(paint)
                :drawText(styledString, 0, 0)
        end)
    end
end

return StyledStringPointStamp
